﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class NewsLetters : BusinessBaseClass
    {

        public NewsLetters()
        {

        }

        public NewsLetters(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("NewsLettersID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("NewsLettersID"));
            EmailSubject = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("EmailSubject")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("EmailSubject"));
            EmailMessage = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("EmailMessage")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("EmailMessage"));
            IsNewsLetterSent = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsNewsLetterSent")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsNewsLetterSent"));
            UserAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));
        }

        [DataObjectField(true, false, false)]
        public override Guid UniqueID { get; set; }

        public string EmailSubject { get; set; }

        public string EmailMessage { get; set; }

        public bool IsNewsLetterSent { get; set; }

        public Guid UserAccountID { get; set; }

        public override DateTime CreatedDate { get; set; }

        public override DateTime ModifiedDate { get; set; }

        public override GlobalConfigurations.Mode Mode { get; set; }

        public override bool IsActive { get; set; }
    }
}
